/*
    module: Libc

    author: Marc Wolfgram
      date: 11-Sep-88
   revised: 06-Nov-88 GetDate completed
            20-Jan-89 GetDate optimized
            19-Jun-89 Orca/C

            Copyright (c) 1988 by Marc Wolfgram and Associates
            1808 Michael Drive, Waukesha, WI 53186 414/549-9261
*/
#include <stdio.h>
#include <stdlib.h>
#include <strino.h>
#include <time.h>

#pragma optimize -1
#pragma keep "datelib"
#pragma memorymodel 0

/*
 *  GetDate(str);   Fills str with date and time of call in the form
 *  char str[26];           "Sun Jul 15 16:48:30 1989\0"
 *                           01234567890123456789012345
 */

void GetDate(char *DateStr)
{
    time_t t;
    t = time(0L);
    strncpy(DateStr, ctime(&t), 24);
    DateStr[24] = '\0';
}

/*
 *  Cant(p, f, e);  Displays "PRG: Can't open FILE" on stderr.  Exits with
 *  char *p, *f;    termination status set to e if e is non-zero.  p and f
 *  int e;          are pointers to the program and file names respectively.
 */

void Cant(char *p, char *f, int e)
{
    fprintf(stderr,"%s: Can't open %s\n", p, f);
    if (!e)
        exit(e);
}
